/* concat
   Copies the given files to stdout
   Reuben Thomas (rrt@sc3d.org)
   v0.1 27/11/99
*/

#include <stdio.h>

int main(int argc, char *argv[])
{
    int i, c;

    if (argc > 1)
        for (i= 1; i < argc; i++) {
            if (strcmp(argv[i], "-") && !freopen(argv[i], "rb", stdin)) {
                fprintf(stderr," can't open %s\n", argv[i]);
                exit(1);
            }

            while ((c= getchar()) != EOF) putchar(c);
        }
    else printf(
        "concat v0.1 by Reuben Thomas (rrt@sc3d.org)\n"
        "Copies files to standard output\n"
        "\n"
        "Usage: concat file...\n"
        "  In the file list, \'-\' means read from standard input\n");

    return 0;
}
